# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   config = entMan.lookup( 'configTag/config' )
   configTagPath = config.configTagEntry.fullName

   # Since tagId is generated using prevTagId from a non-config mounted entity,
   # a new tag Id is generated when the debugAttrs check test rolls back the config
   # and creates the same tag again. When this config is commited to global Sysdb,
   # the tagId field for all configTag entries is modified. This is expected.
   CliSession.registerAttributeEditLogBypass( entMan, configTagPath,
         "tagId", "ConfigTag::ConfigTagId", "set" )
