# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   # -------------------------------------------------------------------------
   # Custom entity copy handlers
   # -------------------------------------------------------------------------
   cmgrCopyHandlerDir = CliSession.registerCopyHandlerDir(
         entMan, "ContainerMgr",
         "ContainerMgr::ContainerProfileConfigCopyHandlerDir" )
   cmgrCopyHandlerDir.copyHandler = ()

   containerProfileCopyHandler = cmgrCopyHandlerDir.copyHandler
   containerProfileCopyHandler.initialize()

   CliSession.registerCustomCopyHandler(
         entMan, "",
         "ContainerMgr::ContainerProfileConfigCopyHandler",
         containerProfileCopyHandler )

   profileConfigDir = entMan.lookup( "containerMgr/container/profileConfig" )
   parentPath = profileConfigDir.fullName + '.profile'
   CliSession.registerAttributeEditLogBypass( entMan,
                                              parentPath,
                                              "done",
                                              "U32",
                                              "set" )
