# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   import ConfigSessionPlugin.Intf # pylint: disable=import-outside-toplevel
   # Declare dependancy of eth/phy/slice on global; pointers into other config roots
   # can only be resolved if we do things in the right order. Eth/phy/slice needs
   # global's admin status default setting in order to evaluate its admin status when
   # there is no explicit configuration for it.
   CliSession.registerConfigRootDependency( entMan,
                                          'interface/config/global', # dependee
                                          'interface/config/eth/phy/slice' # depender
                                          )
   copyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                                 "EthIntf",
                                                 "SysdbEthIntf::CopyHandlerDir" )
   eicsd = entMan.lookup( "interface/config/eth/phy*/slice" )

   # Create a custom copy handlers for interface/config/eth/phy/slice
   copyHandlerDir.configDirCopyHandler = ()

   # Setup the first handler for EthPhyIntfConfigDir's
   handler = copyHandlerDir.configDirCopyHandler
   handler.intfConfigSliceDir = eicsd
   handler.filteredAttribute = ()
   for attrName in ConfigSessionPlugin.Intf.intfConfigFilterAttributes:
      handler.filteredAttribute.attributeName[ attrName ] = True
   CliSession.registerCustomCopyHandler( entMan,
                                         "interface/config/eth/phy/slice",
                                         "",
                                         handler, "both" )

   # globalIntfConfig is written by a Sysdb reactor on Status changes; if that 
   # happens right after the commit of a session it will get into the cross-hairs of
   # the debug-attr-on-commit check, so add a bypass.
   CliSession.registerAttributeEditLogBypass(
      entMan, eicsd.fullName, "globalIntfConfig", "", "set" )

   # Need to bypass this for non-Jericho2 platforms.
   globalDefault = entMan.lookup( "interface/config/eth/phy/globalDefault" )
   CliSession.registerAttributeEditLogBypass(
      entMan, globalDefault.fullName + ".xcvrModeConfig/qsfp", "globalMode",
      "Interface::XcvrMode", "set" )
