# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import FabricIntfLib

def Plugin( em ):
   # Due to poorly explained reasons this is guaranteed to be mounted at this stage.
   # Presumably because the configuration session plugins are loaded after
   # ConfigAgent has loaded all configuration mounts.
   fabricIntfConfigDir = em.lookup( FabricIntfLib.Constants.intfConfigPath() )

   copyHandlerDir = CliSession.registerCopyHandlerDir(
      em, 'FabricIntf', 'Interface::FabricIntfCopyHandlerDir' )
   copyHandlerDir.configDirCopyHandler = ( fabricIntfConfigDir, )
   CliSession.registerCustomCopyHandler( em,
                                         FabricIntfLib.Constants.intfConfigPath(),
                                         '',
                                         copyHandlerDir.configDirCopyHandler,
                                         'both')

   # Eventually, fabric interfaces will become fully configurable and will have to
   # rely on the global configuration. When that happens writes to the global
   # configuration should be copied before writes to the fabric interface
   # configuration directories.
   CliSession.registerConfigRootDependency(
      em,
      'interface/config/global',
      FabricIntfLib.Constants.intfConfigPath() )

   # "globalIntfConfig" is written by a Sysdb reactor on Status changes; if that
   # happens right after the commit of a session it will get into the cross-hairs of
   # the debug-attr-on-commit check, so add a bypass.
   #
   # Disclaimer: This code was copied directly from the EthIntf custom copy handler
   #             configuration session plugin. What a "debug-attr-on-commit" check is
   #             remains unclear to the author.
   CliSession.registerAttributeEditLogBypass(
      em, fabricIntfConfigDir.fullName, 'globalIntfConfig', '', 'set' )
