# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import CliSession
import GnmiSetCliSession
import Plugins
import Tac
import Tracing

traceHandle = Tracing.Handle( "ConfigSessionFhrp" )
t0 = traceHandle.trace0

# pkgdeps: rpm Fhrp-lib

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):

   def toNativeFhrpVarpConfigSyncher( cls, sessionName ):
      t0( "Updating virtual addresses in the global collection" )
      ipConfig = AirStreamLib.getSessionEntity( entMan, sessionName, "ip/config" )
      varpConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
                      "routing/fhrp/varp/config" )
      varpConfig.preCommitHandler( ipConfig )

   class VarpIpConfigPreCommitHandler( GnmiSetCliSession.PreCommitHandler ):
      externalPathList = [ 'routing/fhrp/varp/config' ]
      nativePathList = [ 'routing/fhrp/varp/config',
                         'ip/config' ]

      @classmethod
      def run( cls, sessionName ):
         toNativeFhrpVarpConfigSyncher( cls, sessionName )

   # Register the syncher to pre-commit handler
   t0( "AirStreamSet is on. Register pre-commit handler for VarpConfig" )
   GnmiSetCliSession.registerPreCommitHandler( VarpIpConfigPreCommitHandler )
   CliSession.registerConfigGroup( entMan, "airstream-cmv",
                                   'routing/fhrp/varp/config' )
