# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   flowTrackingCopyHandlerDir = CliSession.registerCopyHandlerDir(
         entMan,
         "FlowTrackingConfig",
         "FlowTracking::FlowTrackingConfigCopyHandlerDir" )
   flowTrackingCopyHandlerDir.flowGroupCopyHandler = ()
   flowTrackingCopyHandlerDir.flowTrackerCopyHandler = ()

   flowGroupHandler = flowTrackingCopyHandlerDir.flowGroupCopyHandler
   flowGroupHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "flowtracking/input/config",
                                         "FlowTracking::FlowGroup",
                                         flowGroupHandler )

   flowTrackerHandler = flowTrackingCopyHandlerDir.flowTrackerCopyHandler
   flowTrackerHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "flowtracking/input/config",
                                         "FlowTracking::FlowTrackerConfig",
                                         flowTrackerHandler )

   # collectorHostAndPort needs to be updated last to guarantee correct syslog.
   # output. Note that the attributes in the entity are in the correct order.
   CliSession.registerEntityCopyFilter( entMan,
                                        "flowtracking/input/config",
                                        "FlowTracking::ExporterConfig",
                                        [],
                                        orderedAttrsAfter=[
                                           'collectorHostAndPort' ] )
