# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Tracing

traceHandle = Tracing.Handle( 'ConfigSession.Intf' )
t0 = traceHandle.trace0

intfConfigFilterAttributes = (
   "defaultConfig", "enabledStateLocal", "enabledStateReason", "requestor" )

def registerIntfEntityFilters( em, root, typeName ):
   """ Register filter for the necessary attributes of Interface::IntfConfig.
       This function should be called for all derived types of IntfConfig from
       the corresponding SysdbPlugin. """
   CliSession.registerEntityCopyFilter( em, root, typeName,
                                        intfConfigFilterAttributes )

   t0( "Registered EntityCopy filter for IntfConfig attributes in root", root )

def Plugin( entMan ):
   CliSession.registerAttributeEditLogBypass(
      entMan, 'interface/config', "adminEnabledStateLocal",
      "Interface::IntfEnabledState", "set" )
