# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   ipsecConfig = entMan.lookup( 'ipsec/ike/config' )

   # We need bypass the 'set' attr edit log for the ipsecModeExit attribute
   # If we exit from the ipsecConfigMode more than twice before we do the
   # config replace, we will hit the 'set' ( modify ) log because we only exit
   # from the ipsecConfigMode once in the config session ( 2 != 1 )
   CliSession.registerAttributeEditLogBypass(
      entMan, ipsecConfig.fullName, "ipsecModeExit",
      "U32", "set", None )

   # we need to add the attribute edit log bypass due to the randomness of
   # "SecretCliLib::Secret" attributes salt and initial vector.
   profilePath = ipsecConfig.fullName + ".ipsecProfile"
   CliSession.registerAttributeEditLogBypass( entMan, profilePath,
                                              "profileParams",
                                              "Ipsec::Ike::IpsecProfileParams",
                                              "set" )
