# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   CliSession.registerConfigRootDependency( entMan,
                                            'interface/config/eth/lag',
                                            'lag/input/config/cli' )
   intfConfig = entMan.lookup( 'interface/config/eth/lag' )
   lagConfigCli = entMan.lookup( 'lag/input/config/cli' )

   # pylint: disable-next=import-outside-toplevel
   import ConfigSessionPlugin.Intf # pylint: disable-msg=F0401
   ConfigSessionPlugin.Intf.registerIntfEntityFilters(
      entMan, "interface/config/eth/lag", "Interface::EthLagIntfConfig" )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   # Let's do some audit on lagConfigCli.phyIntf attrs when deleting 
   aeBypassDefault = None
   if attrEditBypassParentDir:
      aeBypassDefault = attrEditBypassParentDir.newEntity(
         "Lag::AttrEditBypassDefault", "Lag" ) 
      aeBypassDefault.ethPhyIntfLagConfig = ( "", )
   CliSession.registerAttributeEditLogBypass(
      entMan, lagConfigCli.fullName, "phyIntf", "Lag::EthPhyIntfLagConfig", "del",
      aeBypassDefault.ethPhyIntfLagConfig if aeBypassDefault else None )
   CliSession.registerAttributeEditLogBypass(
      entMan, intfConfig.fullName, "mode", "Interface::LagMode", "set" )

