#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import CliSession
import GnmiSetCliSession
import Tac
from Toggles.LoopProtectToggleLib import toggleLoopProtectOpenConfigEnabled

# pkgdeps: rpm LoopProtect-lib

def Plugin( entMan ):
   if toggleLoopProtectOpenConfigEnabled():
      class ToNativeLoopProtectHandler( GnmiSetCliSession.PreCommitHandler ):
         externalPathList = [ "loopprotect/openconfig/config" ]
         nativePathList = [ "loopprotect/config" ]

         @classmethod
         def run( cls, sessionName ):
            externalConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
               "loopprotect/openconfig/config" )
            nativeConfig = AirStreamLib.getSessionEntity( entMan, sessionName,
               "loopprotect/config" )
            helper = Tac.newInstance( "LoopProtect::LoopProtectOpenConfigHelper",
               externalConfig, nativeConfig )
            helper.syncExternalToNative()

      CliSession.registerConfigGroup( entMan, "airstream-cmv",
                                      "loopprotect/openconfig/config" )
      GnmiSetCliSession.registerPreCommitHandler( ToNativeLoopProtectHandler )
      AirStreamLib.registerCopyHandler( entMan, "LoopProtectOpenConfig",
         typeName="LoopProtect::OpenConfig::Config" )
