# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   _tapAggPmapConfig = entMan.lookup( "tapagg/pmapconfig" )
   _tapAggCliConfig = entMan.lookup( "tapagg/cliconfig" )

   # The order is already ok (as defined by the Tac model). The reason
   # we use entityCopyFilter is that it adds the orderedAttrsBefore to the
   # copied() collection to allow the ptrs to tapAggActions in pmapType to
   # be resolved, rather than deferred.
   CliSession.registerEntityCopyFilter( entMan, "", "TapAgg::PmapConfig", [],
                                        orderedAttrsBefore=[ "tapAggActions",
                                                             "cmapType" ])

   # Custom EntityCopy handler for TapAgg and PolicyMap types
   policyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                 "TapAggPmapConfig",
                                 "TapAgg::TapAggPmapConfigCopyHandlerDir" )
   policyHandlerDir.copyHandler = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         "tapagg/pmapconfig",
                                         "TapAgg::PmapConfig",
                                         policyHandlerDir.copyHandler )

   cliConfigHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                 "TapAggCliConfig",
                                 "TapAgg::TapAggCliConfigCopyHandlerDir" )
   cliConfigHandlerDir.copyHandler = ( _tapAggCliConfig, )
   handler = cliConfigHandlerDir.copyHandler
   handler.initialize()
   CliSession.registerCustomCopyHandler( entMan, "tapagg/cliconfig",
                                         "TapAgg::CliConfig",
                                         handler )

   # Ignore attribute changes in this path.
   tapAggActionPath = _tapAggPmapConfig.fullName + ".tapAggActions"
   tapAggPmapPath = _tapAggPmapConfig.fullName + ".pmapType.pmap"
   CliSession.registerAttributeEditLogBypass( entMan, tapAggActionPath,
                                              "", "", "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, tapAggActionPath,
                                              "", "", "del", None )
   CliSession.registerAttributeEditLogBypass( entMan, tapAggPmapPath,
                                              "", "", "set", None )

   # Mirroring config copy handler
   configHandlerDir = CliSession.registerCopyHandlerDir(
      entMan,
      "Mirroring",
      "Mirroring::MirroringConfigCopyHandlerDir" )
   configHandlerDir.copyHandler = ()
   handler = configHandlerDir.copyHandler
   handler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "Mirroring::Config",
                                         handler )
