#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Toggles.MlagToggleLib

# This is a temporary plugin while mlagL2Subinterfaces toggle exists. This way,
# we can control which of 'mlag/config' or 'mlag/input/cli/config' is the
# 'configRoot' for the Mlag agent based on the toggle state. See also
# MlagCopyHandler.tac/tin, which were necessary to implement the mlag copy handler

def Plugin( em ):
   if Toggles.MlagToggleLib.toggleMlagL2SubinterfacesEnabled():
      mlagHandlerDir = \
         CliSession.registerCopyHandlerDir( em,
                                            "Mlag",
                                            "Mlag::MlagCopyHandlerDir" )
      mlagHandlerDir.mlagCopyHandler = ()
      mlagHandler = mlagHandlerDir.mlagCopyHandler
      mlagHandler.filteredAttribute = ()
      CliSession.registerCustomCopyHandler( em, "mlag/config", "Mlag::Config",
                                            mlagHandler )
