# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   config = entMan.lookup( "routing6/ospf3/config" )
   intfConfigPath = config.fullName + '.intfConfig'
   vrfConfigPath = config.fullName + '.vrfConfig'
   # we need to add the attribute edit log bypass due to the randomness of
   # "SecretCliLib::Secret" attributes salt and initial vector.
   for action in [ "set", "del" ]:
      CliSession.registerAttributeEditLogBypass( entMan, intfConfigPath, "sa", 
                     "Routing6::Ospf3::Ospf3SecurityAssociation", action )
      CliSession.registerAttributeEditLogBypass( entMan, vrfConfigPath, "sa",
                     "Routing6::Ospf3::Ospf3SecurityAssociation", action )
