# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   phyCli = entMan.lookup( "hardware/phy/config/cli" )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   defaultPhyCliConfig = None
   defaultPhyCliCoherentConfig = None
   if attrEditBypassParentDir:
      bypassPhyCliConfigDir = attrEditBypassParentDir.newEntity(
         "Hardware::Phy::PhyCliConfigDir", "PhyEee" )
      defaultPhyCliConfig = bypassPhyCliConfigDir.phyCliConfig.newMember( "" )
      defaultPhyCliCoherentConfig = \
            bypassPhyCliConfigDir.phyCliCoherentConfig.newMember( "" )
   CliSession.registerAttributeEditLogBypass( entMan, phyCli.fullName,
                                              "phyCliConfig",
                                              "Hardware::Phy::PhyCliConfig", "del",
                                              defaultPhyCliConfig )
   CliSession.registerAttributeEditLogBypass( entMan, phyCli.fullName,
                                              "phyCliCoherentConfig",
                                              "Hardware::Phy::PhyCliCoherentConfig", 
                                              "del",
                                              defaultPhyCliCoherentConfig )

   # EntityCopy handler for PhyFeatureConfig
   phyFeatureConfigCopyHandlerDir = CliSession.registerCopyHandlerDir(
         entMan, "PhyFeatureConfig",
         "Hardware::Phy::PhyFeatureConfigCopyHandlerDir" )
   phyFeatureConfigCopyHandlerDir.phyFeatureConfigCopyHandler = ()
   phyFeatureConfigCopyHandler = \
      phyFeatureConfigCopyHandlerDir.phyFeatureConfigCopyHandler
   phyFeatureConfigCopyHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan, "",
                                         "Hardware::Phy::PhyFeatureConfigDir",
                                         phyFeatureConfigCopyHandler )
