# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   # Custom EntityCopy handlers for PolicyMap types
   policyHandlerDir = CliSession.registerCopyHandlerDir(
      entMan,
      "PolicyMapConfig",
      "PolicyMap::PolicyMapCopyHandlerDir" )
   policyHandlerDir.copyHandler = ()
   handler = policyHandlerDir.copyHandler
   handler.initialize()
   CliSession.registerCustomCopyHandler( entMan, "",
                                         "PolicyMap::PolicyMapConfig",
                                         handler )

   classHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                "ClassMapConfig",
                                "PolicyMap::ClassMapCopyHandlerDir" )
   classHandlerDir.copyHandler = ()
   handler = classHandlerDir.copyHandler
   handler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "",
                                         "PolicyMap::ClassMapConfig",
                                         handler )
