# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Plugins
import Tac

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   portsecConfig = entMan.lookup( "portsec/config" )

   attrEditBypassParentDir = CliSession.attributeEditBypassDir( entMan )
   aeBypassDefault = None
   if attrEditBypassParentDir:
      configDir = attrEditBypassParentDir.newEntity(
            "PortSec::Config",
            "FakeConfigDir" )
      psiConf = Tac.Value( 'PortSec::IntfConfig',
                           Tac.Value( 'Arnet::IntfId', 'Ethernet1' ) )
      aeBypassDefault = configDir.intfConfig.addMember( psiConf )
   CliSession.registerAttributeEditLogBypass( entMan,
                                              portsecConfig.fullName,
                                              "intfConfig",
                                              "PortSec::IntfConfig",
                                              "del",
                                              aeBypassDefault )

