# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AirStreamLib
import GnmiSetCliSession
import Plugins
import Tracing
from QosTypes import tacTxQueueId

t0 = Tracing.Handle( "OpenConfigQos" ).trace0

@Plugins.plugin( requires=( 'session', ) )
def Plugin( entMan ):
   # precommit handlers
   #    - Forwarding Groups
   class ToNativeForwardingGroupSyncher( GnmiSetCliSession.PreCommitHandler ):
      externalPathList = [ 'qos/openconfig/config/forwardingGroups' ]
      nativePathList = [ 'qos/input/config/cli' ]

      @classmethod
      def run( cls, sessionName ):
         forwardingGroups = AirStreamLib.getSessionEntity(
            entMan, sessionName, 'qos/openconfig/config/forwardingGroups' )
         cliConfig = AirStreamLib.getSessionEntity(
            entMan, sessionName, 'qos/input/config/cli' )
         forwardingGroupNameToTcMap = cliConfig.forwardingGroupNameToTcMap
         queueNameToTxQueueIdMap = cliConfig.queueNameToTxQueueIdMap
         tcToForwardingGroupNameMap = {}
         maxTc = 7
         maxQId = 7
         # update the reverse mappings
         for fgName, tc in forwardingGroupNameToTcMap.\
               forwardingGroupNameToTc.items():
            tcToForwardingGroupNameMap[ tc ] = fgName

         def updateTcToTxQueueMap( tc, qId ):
            if tc > maxTc:
               return
            if qId <= maxQId:
               cliConfig.tcToTxQueueMap[ tc ] = qId
            else:
               cliConfig.tcToTxQueueMap[ tc ] = tacTxQueueId.invalid

         for tc in range( maxTc + 1 ):
            t0( f"tc: {tc}" )
            fgName = tcToForwardingGroupNameMap.get( tc )
            if fgName is None:
               continue
            t0( f"forwardingGroup: {fgName}" )
            qId = tacTxQueueId.invalid
            forwardingGroup = \
               forwardingGroups.forwardingGroup.get( fgName )
            if forwardingGroup:
               forwardingGroupConfig = forwardingGroup.config
               outputQueue = forwardingGroupConfig.outputQueue
               if outputQueue:
                  qId = \
                     queueNameToTxQueueIdMap.queueNameToTxQueueId.get( outputQueue )
                  t0( f"qId: {qId}" )
                  t0( f"queueName: {outputQueue}" )
                  if qId is None:
                     qId = tacTxQueueId.invalid
            updateTcToTxQueueMap( tc, qId )

   GnmiSetCliSession.registerPreCommitHandler( ToNativeForwardingGroupSyncher )
