# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession

def Plugin( entMan ):
   aclConfig = entMan.lookup( 'routing/acl/config' )

   # EntityCopy handler for RouteMap::Map
   routeMapHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                   "RouteMap",
                                   "Routing::RouteMap::RouteMapCopyHandlerDir" )

   # Register route map copy handler
   registerRouteMapCopyHandler( entMan, routeMapHandlerDir, "" )

   # EntityCopy handler for RouteMap::MapEntry
   routeMapEntryHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                "RouteMapEntry",
                                "Routing::RouteMap::RouteMapEntryCopyHandlerDir" )

   registerRouteMapEntryCopyHandler( entMan, routeMapEntryHandlerDir, "" )
   routeMapHandlerDir.routeMapCopyHandler.routeMapEntryCopyHandler = (
         routeMapEntryHandlerDir.routeMapEntryCopyHandler )

   # Edit log by pass filters for community and as-path prepend versions
   rmConfigPath = entMan.lookup( 'routing/routemap/config' ).fullName
   for attr in [ 'communityAddReplaceVersion', 'communityDeleteVersion',
                 'extCommunityVersion', 'asPathPrependUpdateCount',
                 'asPathReplaceUpdateCount', 'largeCommunityVersion',
                 'communityFilterVersion', 'extCommunityFilterVersion',
                 'largeCommunityFilterVersion', 'versionId' ]:
      CliSession.registerAttributeEditLogBypass( entMan, rmConfigPath, attr, 'U32',
                                                 'set' )

   # community list entry copy handler
   registerCommunityListCopyHandler( entMan, routeMapHandlerDir, "" )

   CliSession.registerAttributeEditLogBypass( entMan, aclConfig.fullName,
                                              'prefixListModeCount',
                                              'U32', 'set' )
   prefixListPath = aclConfig.fullName + ".prefixList"
   CliSession.registerAttributeEditLogBypass( entMan, prefixListPath,
                                              'version',
                                              'U32', 'set' )
   CliSession.registerAttributeEditLogBypass( entMan, prefixListPath,
                                              'sourceTimestamp',
                                              'U32', 'set' )
   CliSession.registerAttributeEditLogBypass( entMan,  prefixListPath,
                                              'inPrefixListMode',
                                              'bool', 'set' )
   ipv6PrefixListPath = aclConfig.fullName + ".ipv6PrefixList"
   CliSession.registerAttributeEditLogBypass( entMan, ipv6PrefixListPath,
                                              'sourceTimestamp',
                                              'U32', 'set' )
   # Prefix-list copy handler
   registerPrefixListCopyHandler( entMan, routeMapHandlerDir, "" )

   # ipv6 Prefix-list copy handler
   registerIp6PrefixListCopyHandler( entMan, routeMapHandlerDir, "" )

   # aspath-list copy handler
   registerAsPathListCopyHandler( entMan, routeMapHandlerDir, "" )

   pathListPath = aclConfig.fullName + ".pathList"
   CliSession.registerAttributeEditLogBypass( entMan, pathListPath,
                                              'sourceTimestamp',
                                              'U32', 'set' )

def registerRouteMapCopyHandler( entMan, handlerDir, path ):
   handlerDir.routeMapCopyHandler = ()
   routeMapHandler = handlerDir.routeMapCopyHandler
   # changes made to the attribute filters should be replicated in
   # copyOrRenameRouteMapMode under
   # RouteMap/CliPlugin/RouteMapCli.py
   routeMapHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         path,
                                         "Routing::RouteMap::Map",
                                         routeMapHandler )
   routeMapHandler.filteredAttribute.attributeName[ 'version' ] = True
   # `mapEntry` collection is copied manually in `handleEntity`
   routeMapHandler.filteredAttribute.attributeName[ 'mapEntry' ] = True

def registerRouteMapEntryCopyHandler( entMan, handlerDir, path ):
   handlerDir.routeMapEntryCopyHandler = ()
   routeMapEntryHandler = handlerDir.routeMapEntryCopyHandler
   routeMapEntryHandler.filteredAttribute = ()
   routeMapEntryHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         path,
                                         "Routing::RouteMap::MapEntry",
                                         routeMapEntryHandler )
   routeMapEntryHandler.filteredAttribute.attributeName[ 'versionId' ] = True

def registerCommunityListCopyHandler( entMan, handlerDir, path ):
   handlerDir.communityListEntryCopyHandler = ()
   communityListEntryHandler = handlerDir.communityListEntryCopyHandler
   communityListEntryHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         path,
                                         "Acl::CommunityListEntry",
                                         communityListEntryHandler )
   communityListEntryHandler.filteredAttribute.attributeName[ 'version' ] = True

def registerPrefixListCopyHandler( entMan, handlerDir, path ):
   handlerDir.prefixListCopyHandler = ()
   prefixListHandler = handlerDir.prefixListCopyHandler
   # changes made to the attribute filters should be replicated in
   # copyOrRenamePrefixList under RouteMap/CliPlugin/RouteMapCli.py
   prefixListHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         path,
                                         "Acl::PrefixList",
                                         prefixListHandler )
   prefixListHandler.filteredAttribute.attributeName[ 'version' ] = True

def registerIp6PrefixListCopyHandler( entMan, handlerDir, path ):
   handlerDir.ipv6PrefixListCopyHandler = ()
   ipv6PrefixListHandler = handlerDir.ipv6PrefixListCopyHandler
   # changes made to the attribute filters should be replicated in
   # copyOrRenamePrefixList under RouteMap/CliPlugin/RouteMapCli.py
   ipv6PrefixListHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         path,
                                         "Acl::Ipv6PrefixList",
                                         ipv6PrefixListHandler )
   ipv6PrefixListHandler.filteredAttribute.attributeName[ 'version' ] = True

def registerAsPathListCopyHandler( entMan, handlerDir, path ):
   handlerDir.asPathListCopyHandler = ()
   asPathListHandler = handlerDir.asPathListCopyHandler
   asPathListHandler.filteredAttribute = ()
   CliSession.registerCustomCopyHandler( entMan,
                                         path,
                                         "Acl::AsPathList",
                                         asPathListHandler )
   asPathListHandler.filteredAttribute.attributeName[ 'version' ] = True
