# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSession
import Tracing

t0 = Tracing.Handle( "ConfigSessionStp" ).trace0
t9 = Tracing.Handle( "ConfigSessionStp" ).trace9

def Plugin( entMan ):
   # EntityCopy handlers for MstiConfig
   mstiConfigHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                     "StpMstiConfig",
                                     "Stp::MstiConfigCopyHandlerDir" )
   mstiConfigHandlerDir.copyHandler = ()
   mstiConfigHandler = mstiConfigHandlerDir.copyHandler
   mstiConfigHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "stp/input/config",
                                         "Stp::Input::MstiConfig",
                                         mstiConfigHandler )

   # EntityCopy handlers for StpiConfig
   stpiConfigHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                     "StpStpiConfig",
                                     "Stp::StpiConfigCopyHandlerDir" )
   stpiConfigHandlerDir.copyHandler = ()
   stpiConfigHandler = stpiConfigHandlerDir.copyHandler
   stpiConfigHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "stp/input/config",
                                         "Stp::Input::StpiConfig",
                                         stpiConfigHandler )


   # EntityCopy handlers for StpConfig
   stpConfigHandlerDir = CliSession.registerCopyHandlerDir( entMan,
                                     "StpConfig",
                                     "Stp::StpConfigCopyHandlerDir" )
   stpConfigHandlerDir.copyHandler = ()
   stpConfigHandler = stpConfigHandlerDir.copyHandler
   stpConfigHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan,
                                         "stp/input/config",
                                         "Stp::Input::Config",
                                         stpConfigHandler )
