# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliSession

def Plugin( entMan ):
   config = entMan.lookup( "trafficPolicies/input/cli" )
   fsConfig = entMan.lookup( "trafficPolicies/fieldset/input/cli" )

   CliSession.registerEntityCopyFilter( entMan,
                                        "", "TrafficPolicy::TrafficPolicyConfig", [],
                                        orderedAttrsBefore=[ "actions" ] )
   # Custom Copy handler for Config
   tpCopyHandlerDir = CliSession.registerCopyHandlerDir( entMan,
         "TrafficPolicyConfig", "TrafficPolicy::TrafficPolicyCopyHandlerDir" )
   tpCopyHandlerDir.tpCopyHandler = ()
   tpCopyHandlerDir.tpCopyHandler.initialize()
   CliSession.registerCustomCopyHandler( entMan, "",
                                         "TrafficPolicy::TrafficPolicyConfig",
                                         tpCopyHandlerDir.tpCopyHandler )

   # Ignore attribute changes in this path.
   tpActionPath = config.fullName + ".actions"
   tpPmapPath = config.fullName + ".pmapType.pmap"
   # Ignore field-set path changes as subconfig pointer will change
   fsPath = fsConfig.fullName

   CliSession.registerAttributeEditLogBypass( entMan, tpActionPath,
                                              "", "", "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, tpActionPath,
                                              "", "", "del", None )
   CliSession.registerAttributeEditLogBypass( entMan, tpPmapPath,
                                              "", "", "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, fsPath,
                                              "", "", "set", None )
   CliSession.registerAttributeEditLogBypass( entMan, fsPath,
                                              "", "", "del", None )
