# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import QuickTrace
import Tac
import Tracing

traceHandle = Tracing.Handle( "ContainerMgrCommon" )

t0 = traceHandle.trace0 # function calls
t1 = traceHandle.trace1 # error/exception
t2 = traceHandle.trace2 # login/logout from a registry
t3 = traceHandle.trace3 # container info traces

qv = QuickTrace.Var
qt0 = QuickTrace.trace0 # Important function calls
qt1 = QuickTrace.trace1 # error/exception
qt2 = QuickTrace.trace2 # Other important info

def serviceInstalled():
   return os.path.exists( "/usr/bin/docker" )

def runCmd( cmd, desc ):
   t3( desc )
   qt2( qv( desc ) )

   hasFailed = False
   errText = ""

   try:
      Tac.run( cmd, stdout=Tac.DISCARD, stderr=Tac.CAPTURE )
   except Tac.SystemCommandError as e:
      hasFailed = True
      errText = e.output

   if hasFailed:
      t1( desc, f"failed with error {errText}" )
      qt1( qv( desc ), "failed with error", qv( errText ) )
   else:
      t3( desc, "successful" )
      qt2( qv( desc ), "successful" )

   return hasFailed, errText
