# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def Plugin( entityManager ):
   # Registration to receive mounts from controllerdb
   # The mount points from the switches are mounted as Tac::Dir and at a later
   # point the switch-specific subdir will be type casted to the appropriate tac type

   # Register MssL3 service with the service manager
   entityManager.registerService( serviceName="MssL3" )

   # Register the followings to get the mounts from the switch. Note
   # 'vxlan/version2/vtepStatusDir/switch' is already registered in VxlanController's
   # Controllerdb plugin. So, we don't need to register it here again.

   # Publish mounts. Configurations published to each VTEP.
   entityManager.register( "mssl3/version1/global/groupTypeConfig/config",
                           "MssL3::V1::GroupTypeConfig" )
   entityManager.register( "mssl3/version1/global/groupSetConfig", "Tac::Dir" )
   entityManager.register( "mssl3/version1/global/fragmentConfig", "Tac::Dir" )

   # Controller mounts (Shared with MssL2 agent)
   entityManager.register( 'mssclient/version1/capability/switch', 'Tac::Dir' )

   # Controller mounts. Status published by MssClient back to CVX
   entityManager.register( 'mssclientl3/version1/global/groupTypeStatus/switch',
                           'Tac::Dir' )
   entityManager.register( 'mssclientl3/version1/global/groupSetStatus/switch',
                           'Tac::Dir' )
   entityManager.register( 'mssclientl3/version1/global/fragmentStatus/switch',
                           'Tac::Dir' )

   # Publish mounts. Configurations published to each VTEP for V2 version
   entityManager.register( "mssl3/version2/global/config/mss",
                           "MssL3::V2::GlobalConfig" )
   entityManager.register( "mssl3/version2/global/groupTypeConfig/config",
                           "MssL3::V2::GroupTypeConfig" )
   entityManager.register( "mssl3/version2/global/groupSetConfig", "Tac::Dir" )
   entityManager.register( "mssl3/version2/global/fragmentConfig", "Tac::Dir" )
   entityManager.register( "mssl3/version2/global/networkVrfMapping", "Tac::Dir" )

   # Controller mounts. Status published by MssClient back to CVX for V2 version
   entityManager.register( 'mssclientl3/version2/global/groupTypeStatus/switch',
                           'Tac::Dir' )
   entityManager.register( 'mssclientl3/version2/global/groupSetStatus/switch',
                           'Tac::Dir' )
   entityManager.register( 'mssclientl3/version2/global/fragmentStatus/switch',
                           'Tac::Dir' )
