# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def Plugin( entMan ):

   # Mountpoint for the dynvlan/allowedvlan config for v2 Openstack switches
   entMan.register( 'controllerProxyAgent/v1/portVlanConfigDir/openstack/switch',
         'Tac::Dir' )

   # Mountpoint to check on dynvlan/allowedvlan config errors for v2 Openstack
   # switches
   entMan.register( 'controllerProxyAgent/v1/portVlanErrorStatusDir/switch',
         'Tac::Dir' )

   # register with service manager
   # We are using 'OpenStack' instead of 'VirtualNetwork' as a workaround for
   # BUG383056
   #
   # As it is discussed in more details in http://reviewboard/r/221920 the plan is:
   # - VirtualNetwork service agent to use 'OpenStack' to register with Controllerdb,
   # - OpenStack service agent to use different name to register with Controllerdb,
   # - To add 'virtualnetwork' as a new service to ControllerProxyAgent on the switch
   #   side for forward compatibility.
   #   By adding the new service to the switch-side, there will be no need to
   #   upgrade switches after couple of EOS releases when transitioning to use
   #   VirtualNetwork service.
   entMan.registerService( serviceName="OpenStack" )
