# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins, Tracing
from AclLib import aclTypes, serviceAclTypes

t0 = Tracing.trace0

def registerService( entMan, service, preService="", postService="" ):
   paramCfg = entMan.lookup( 'acl/paramconfig' )
   serviceConfig = paramCfg.newService( service )
   serviceConfig.preService = preService
   serviceConfig.postService = postService

@Plugins.plugin( provides=( 'acl/config/cli', 
                            'acl/paramconfig',
                            'acl/intf/config/cli',
                            'acl/cpconfig/cli' ) )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "ACL" )

   intfCfg = entMan.lookup( 'acl/intf/config/cli' )
   intfCfg.registerAclIntfInput( 10 )
   secMonCfg = entMan.lookup( 'acl/intf/config/input/secure-monitor' )
   secMonCfg.registerAclIntfInput( 8 )

   cfg = entMan.lookup( 'acl/config/cli' )
   cpCfg = entMan.lookup( 'acl/cpconfig/cli' )
   # populate types
   for t in aclTypes:
      cfg.newConfig( t )
   for t in serviceAclTypes:
      cpCfg.newCpConfig( t )
