# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import SysdbUtil
import Plugins, Tac
import DefaultConfigPlugin.Acl

@Plugins.plugin( provides = ( 'maintenance/profile/config/bgp',
                              'maintenance/mapping/member/bgp' ),
                 requires=( 'acl/paramconfig', ) )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, 'BGP' )
   SysdbUtil.addLogFacility( entMan, 'TCP' )

   DefaultConfigPlugin.Acl.registerService( entMan, 'bgp', postService='bgpsacl' )
   DefaultConfigPlugin.Acl.registerService( entMan, 'bgpsacl', preService='bgp' )

   defBgpProfile = entMan.lookup( 'maintenance/profile/config/default/bgp' )

   defBgpProfile.profileName = Tac.Type(
      'Maintenance::Profile::DefaultProfile' ).systemDefaultProfileName
