# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins
import DefaultConfigPlugin.HttpService

@Plugins.plugin( requires=[ "mgmt/capi/config" ] )
def Plugin( entityManager ):
   SysdbUtil.addLogFacility( entityManager, "CAPI" )
   DefaultConfigPlugin.HttpService.registerHttpServiceConfig( entityManager,
                                                              'http-commands' )
   config = entityManager.lookup( 'mgmt/capi/config' )
   config.serviceAclTypeVrfMap = ( 'Capi', )
