#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSchedulerLib, Plugins

@Plugins.plugin()
def Plugin( entMan ):
   config = entMan.lookup( "sys/clischeduler/config" )

   # Default values of interval and weeksOfHistory can be different for
   # different CLI commands. Hence even though currently we only schedule
   # execution of "show tech-support" CLI command, the values are not being
   # hardcoded in TAC model
   ScheduledCli = Tac.Type( "System::CliScheduler::ScheduledCli" )
   schedConfig = ScheduledCli( CliSchedulerLib.showTechJobName,
                     CliSchedulerLib.showTechCliCommand,
                     CliSchedulerLib.scheduleNow,
                     CliSchedulerLib.scheduleNow,
                     CliSchedulerLib.showTechIntervalDefault,
                     CliSchedulerLib.showTechMaxLogFilesDefault,
                     CliSchedulerLib.showTechMaxTotalSizeDefault,
                     CliSchedulerLib.showTechVerboseDefault,
                     CliSchedulerLib.timeoutDefault * 60,
                     logDir=CliSchedulerLib.logPrefixDefault,
                     compressAlgo=CliSchedulerLib.compressAlgoDefault )
   config.scheduledCli.addMember( schedConfig )
