# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Plugins
import Tac

from Toggles.EventMonToggleLib import toggleFecBackupactivationEnabled

@Plugins.plugin( provides=[ 'eventMon/config' ] )
def Plugin( entMan ):
   if not toggleFecBackupactivationEnabled():
      return

   config = entMan.lookup( 'eventMon/config' )

   # Should we generate the default state from a yaml tag?
   config.table.newMember( 'backupactivation', False )
   shaqCfg = Tac.Value( 'EventMon::ShaqConfig' )
   config.table[ 'backupactivation' ].eventConfig = \
      Tac.Value( 'EventMon::EventConfig', shaq=shaqCfg )
