#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Tac, Tracing

t0 = Tracing.trace0
tacPortProfileType = Tac.Type( "InbandTelemetry::PortProfileType" )
tacCollectorType = Tac.Type( "InbandTelemetry::CollectorType" )

def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "INT" )
   intCfg = entMan.lookup( "inbandtelemetry/config" )

   # Adding a collector for log as this is the default collector
   # TODO: when collector log is supported uncomment the below
   # intCfg.collectors.newMember( 'DefaultLog', tacCollectorType.CollectorLog )

   # Adding default profiles for edge and core
   intCfg.edgePortProfiles.newMember( 'default', tacPortProfileType.IntEdge )
   intCfg.edgePortProfiles[ 'default' ].version = 1
   intCfg.corePortProfiles.newMember( 'default', tacPortProfileType.IntCore )
   intCfg.corePortProfiles[ 'default' ].version = 1

   # TODO: when collector log is supported uncomment the below
   # edgeProfile = intCfg.edgePortProfiles[ 'default' ]
   # edgeProfile.collectorName = "DefaultLog"


