# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins, Tac

@Plugins.plugin( provides = ( 'maintenance/profile/config/interface',
                              'maintenance/mapping/member/interface', ) )
def Plugin( entityMgr ):
   SysdbUtil.addLogFacility( entityMgr, 'LINEPROTO' )
   SysdbUtil.addLogFacility( entityMgr, 'CLEAR' )
   # pre-populate default interface profile name
   defIntfProfile = entityMgr.lookup(
               'maintenance/profile/config/default/interface' )
   defIntfProfile.profileName = Tac.Type(
      'Maintenance::Profile::DefaultProfile' ).systemDefaultProfileName
