# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import DefaultConfigPlugin.Acl
from Toggles.AclToggleLib import toggleIpsecServiceAclEnabled

@Plugins.plugin( provides=( 'ipsec/ike/config', ),
                 requires=( 'acl/paramconfig', ) )
def Plugin( entMan ):
   if toggleIpsecServiceAclEnabled():
      # Create service ACL chains IPSEC and ESP
      DefaultConfigPlugin.Acl.registerService( entMan, 'ipsec' )
      DefaultConfigPlugin.Acl.registerService( entMan, 'esp' )
