# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Plugins
import DefaultConfigPlugin.Acl

# pkgdeps: rpm Mpls-lib

@Plugins.plugin( requires=( 'acl/paramconfig', ) )
def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, 'LDP' )

   ldpConfigColl = entMan.lookup( "mpls/ldp/ldpConfigColl" )
   ldpConfigColl.config.newMember( 'default' )

   DefaultConfigPlugin.Acl.registerService( entMan, 'ldp' )
