#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins, AaaDefs, Tac

@Plugins.plugin( provides=[ 'security/aaa/local/config' ],
                 requires=[ 'security/aaa/config' ] )
def Plugin( entMan ):
   cfg = entMan.lookup( 'security/aaa/local/config' )

   # Create built-in roles
   def _addRole( name, rules ):
      role = cfg.role.newMember( name )
      for seq, act, regex, modeKey in rules:
         role.rule[ seq ] = Tac.newInstance( 'LocalUser::Rule', 
                                                act, regex, modeKey )

   for name, rules in AaaDefs.authzBuiltinRoles.items():
      _addRole( name, rules )

   # -------------------------------------------------------------------------
   # The "admin" account is special: it must always exist.
   #
   # Create it here with an empty password. If an "admin" password has
   # been configured, then Sysdb will overwrite the empty password
   # with the real one while parsing the startup-config.
   #
   # This does not result in a timing window during which an admin
   # account can briefly exist without a password because no agent's
   # mount of Sysdb can complete before the startup-config file has
   # been completely parsed.
   # -------------------------------------------------------------------------
   if 'admin' not in cfg.acct:
      acct = cfg.newAcct( "admin", "" )
      acct.role = 'network-admin'
