#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing

traceHandle = Tracing.Handle( 'SysdbMaintenance' )
t0 = traceHandle.trace0

def Plugin( entityMgr ):

   defUnitProfile = entityMgr.lookup( 'maintenance/profile/config/default/unit' )
   srcCliEnt = entityMgr.lookup( 'maintenance/unit/input/cli' )
   srcCliEnt.priority = Tac.Type( 'Maintenance::Unit::InputSrc' ).srcCli

   # Pre-populate the unit default profile and its contents are populated by
   # MaintenanceMode agent in unit profile status dir.
   defUnitProfile.profileName = Tac.Type(
   'Maintenance::Profile::DefaultProfile' ).systemDefaultProfileName
