# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

SERVICE_NAME = 'Mcs'

@Plugins.plugin( requires=( 'mgmt/controller/service/config', ) )
def Plugin( em ):
   switchVersions = ( ( 1, 'Media Control Service' ), )
   addServiceInfo( em.serviceClientCtx_, SERVICE_NAME, switchVersions )

   config = em.lookup( 'mcs/switch/controller/config' )
   config.switchHost = ( "", )
   config.heartbeatConfig = ( "", )
   config.sslProfileConfig = ( "", )
