# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config', ) )
def Plugin( entityManager ):
   controllerVersions = ( ( 1, "First version of Macro Segmentation L3 Service" ),
                        ( 2, "Second version of Macro Segmentation L3 Service" ) )

   # Create config state for Mss L3 service
   addServiceInfo( entityManager.serviceCtx_, "MssL3", controllerVersions )
