# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from ServicePluginContext import addServiceInfo

@Plugins.plugin( requires=( 'controller/service/config',
                            'mgmt/controller/service/config' ) )
def Plugin( entMan ):
   controllerVersions = ( ( 2, 'NetworkTopology Service' ),
                          ( 3, 'NetworkTopology Service' ), )
   addServiceInfo( entMan.serviceCtx_, 'NetworkTopology', controllerVersions,
                   enabled=True )
   controllerVersions = ( ( 3, 'NetworkTopology Client' ), )
   addServiceInfo( entMan.serviceClientCtx_, 'NetworkTopology', controllerVersions,
                   enabled=True )
