# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import SysdbUtil
import DefaultConfigPlugin.Acl
from Toggles.RoutingLibToggleLib import toggleOspf2LsdbExportEnabled

@Plugins.plugin( requires=( 'acl/paramconfig', ) )
def Plugin( entityManager ):
   SysdbUtil.addLogFacility( entityManager, 'OPENCONFIG' )
   octaConfig = entityManager.lookup( 'mgmt/octa/config' )
   octaConfig.aftOptions = ( "aft", )
   octaConfig.httpCommands = ( "httpCommands", )
   octaConfig.httpCommands.sandCounters = ( "sandCounters", )
   octaConfig.isisOptions = ( "isis", )
   if toggleOspf2LsdbExportEnabled():
      octaConfig.ospfOptions = ( "ospf", )

   DefaultConfigPlugin.Acl.registerService( entityManager, "gnmi" )
   DefaultConfigPlugin.Acl.registerService( entityManager, "restconf" )
