# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil

def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, 'PORTSECURITY' )
   cfg = entMan.lookup( 'acl/config/input/portsec' )
   cfg.newConfig( 'mac' )

   # Register /persist/local/PortSecAllowedAddr as a file to be replicated
   # to the standby supervisor.
   frConfig = entMan.root()[ 'redundancy' ][ 'fileReplication' ][ 'config' ]
   rc = frConfig.newRequester( "PortSec", "inotify" )
   rc.enabled = True
   allowedAddrFile = 'file:/persist/local/PortSecAllowedAddr'
   rc.newFile( allowedAddrFile, allowedAddrFile )
