# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SysdbUtil
import Tac
from TypeFuture import TacLazyType

ResolutionRibSource = TacLazyType( 'Routing::Rib::ResolutionRibSource' )
TunnelRibNameIdMap = TacLazyType( 'Tunnel::TunnelTable::TunnelRibNameIdMap' )

def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "PSEUDOWIRE" )
   pwConfig = entMan.root().entity[ "pseudowire/config" ]

   # Populate resolutionRibProfileConfig with the default values
   defaultTunnelRibNames = [ TunnelRibNameIdMap.systemColoredTunnelRibName,
                             TunnelRibNameIdMap.systemTunnelRibName ]

   resRibProfConf = Tac.Value( 'Routing::Rib::ResolutionRibProfileConfig' )
   for i, tunnelRibName in enumerate( defaultTunnelRibNames ):
      resRibConf = Tac.Value( 'Routing::Rib::ResolutionRibConfig',
                              ResolutionRibSource.tunnelRib )
      resRibConf.tunnelRibName = tunnelRibName
      resRibProfConf.resolutionMethod[ i ] = resRibConf
   pwConfig.resolutionRibProfileConfig = resRibProfConf
