# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import SysdbUtil
import Tac

statusServer = Tac.enumValue( "ServerProbe::ProbeMethod", "radiusStatusServer" )

def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "SERVERPROBE" )
   config = entMan.lookup( 'serverProbe/config' )
   counters = entMan.lookup( 'serverProbe/counter/status' )
   counterConfig = entMan.lookup( 'serverProbe/counter/config' )
   config.protocolConfig.newMember( 'radius' )
   config.protocolConfig[ 'radius' ].probeMethod = statusServer
   counters.protocolCounters.newMember( 'radius' )
   counterConfig.protocolCounterConfig.newMember( 'radius' )
