# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
import Tac
from IpLibConsts import DEFAULT_VRF
import DefaultConfigPlugin.Acl

@Plugins.plugin( requires=( 'acl/paramconfig', ), provides=( 'snmp/config', ) )
def Plugin( entMan ):
   config = entMan.lookup( 'snmp/config' )
   config.vrf[ DEFAULT_VRF ] = True
   DefaultConfigPlugin.Acl.registerService( entMan, 'snmp-tcp' )
   DefaultConfigPlugin.Acl.registerService( entMan, 'snmp-udp' )
