# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Plugins
from Debug import newDebugMessage

@Plugins.plugin( provides=( 'debug/config/snmp', ) )
def Plugin( entityManager ):
   ''' Create a new debug category called 'snmp'. 
   Look in Debug/Debug.tac for more info'''

   debugConfig = entityManager.lookup( 'debug/config' )

   # The various debug tokens that can be set for snmp. The structure
   # hopefully allows us to enable this for both agentx subagents as well
   # as the master agent.

   snmp = debugConfig.subcategory.newMember( 'snmp', 'SNMP Debugging' )
   snmpAgent = snmp.subcategory.newMember( 'agent', 'Debug SNMP agent' )
   snmpd = snmp.subcategory.newMember( 'snmpd', 'Debug snmpd service' )

   tokensHelp = 'Debug tokens (several can be enabled)'
   snmpdTokens = snmpd.subcategory.newMember( 'tokens', tokensHelp )

   snmpdTokens.messageType.addMember( newDebugMessage( 'trap', 'SNMP Trap' ) )
   snmpdTokens.messageType.addMember( newDebugMessage( 'usmUser', 'SNMP Trap' ) )

   # BUG30145 workaround
   snmpdTokens.messageType.addMember( newDebugMessage( 'agentx',
                                                       'SNMP Master AgentX' ) )

   snmpdTokens.messageType.addMember( newDebugMessage( 'all',
                                                       'All snmpd tracing' ) )

   snmpAgent.messageType.addMember( newDebugMessage( 'enable',
                                    'Enable snmp agent debugging' ) )
   snmpAgentTokens = snmpAgent.subcategory.newMember( 'tokens', tokensHelp )

   snmpAgentTokens.messageType.addMember( newDebugMessage( 'all',
                                          'All SNMP agent tracing' ) )
   snmpAgentTokens.messageType.addMember( newDebugMessage( 'agentx',
                                          'SNMP agent AgentX' ) )
