# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import SysdbUtil
import Tac
from TypeFuture import TacLazyType
from Toggles import IpLibToggleLib

systemTunnelRibName = TacLazyType( "Tunnel::TunnelTable::TunnelRibNameIdMap"
                              ).systemTunnelRibName
systemTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                            ).systemTunnelRibId
systemColoredTunnelRibName = TacLazyType( "Tunnel::TunnelTable::TunnelRibNameIdMap"
                                     ).systemColoredTunnelRibName
systemColoredTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                                   ).systemColoredTunnelRibId
systemTunnelingLdpTunnelRibName = TacLazyType( 
      "Tunnel::TunnelTable::TunnelRibNameIdMap" ).systemTunnelingLdpTunnelRibName
systemTunnelingLdpTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                            ).systemTunnelingLdpTunnelRibId
systemIgpShortcutTunnelRibName = TacLazyType( 
      "Tunnel::TunnelTable::TunnelRibNameIdMap" ).systemIgpShortcutTunnelRibName
systemIgpShortcutTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                                   ).systemIgpShortcutTunnelRibId
systemColoredTunnelingLdpTunnelRibName = TacLazyType(
   "Tunnel::TunnelTable::TunnelRibNameIdMap" ).systemColoredTunnelingLdpTunnelRibName
systemColoredTunnelingLdpTunnelRibId = TacLazyType(
      "Tunnel::TunnelTable::TunnelRibId" ).systemColoredTunnelingLdpTunnelRibId
systemColoredIgpShortcutTunnelRibName = TacLazyType(
   "Tunnel::TunnelTable::TunnelRibNameIdMap" ).systemColoredIgpShortcutTunnelRibName
systemColoredIgpShortcutTunnelRibId = TacLazyType( "Tunnel::TunnelTable::TunnelRibId"
                              ).systemColoredIgpShortcutTunnelRibId

TunnelTableIdentifier = TacLazyType( "Tunnel::TunnelTable::TunnelTableIdentifier" )

def Plugin( entMan ):
   SysdbUtil.addLogFacility( entMan, "TUNNEL" )
   tunnelRibsConfig = entMan.root()[ "tunnel" ][ "tunnelRibs" ][ "config" ]
   systemTunnelRibConfig = tunnelRibsConfig.config.get( systemTunnelRibName )
   if not systemTunnelRibConfig:
      systemTunnelRibConfig = tunnelRibsConfig.config.newMember(
         systemTunnelRibName )
   tunnelTables = [ TunnelTableIdentifier.bgpLuTunnelTable,
                    TunnelTableIdentifier.srTunnelTable,
                    TunnelTableIdentifier.ospfSrTunnelTable,
                    TunnelTableIdentifier.ldpTunnelTable,
                    TunnelTableIdentifier.rsvpLerTunnelTable,
                    TunnelTableIdentifier.nexthopGroupTunnelTable,
                    TunnelTableIdentifier.staticTunnelTable,
                    TunnelTableIdentifier.isisFlexAlgoTunnelTable,
                   ]
   ProtoPrefAction = Tac.Type( "Tunnel::TunnelTable::ProtoPrefAction" )
   prefMapping = Tac.Value( "Tunnel::TunnelTable::ProtoPrefMapping",
                            ProtoPrefAction.prefDefault, 0 )

   for tunnelTable in tunnelTables:
      if tunnelTable not in systemTunnelRibConfig.entry:
         systemTunnelRibConfig.entry.newMember( tunnelTable, prefMapping,
                                                prefMapping )
   for tunnelTable in systemTunnelRibConfig.entry.keys():
      if tunnelTable not in tunnelTables:
         del systemTunnelRibConfig.entry[ tunnelTable ]

   systemColoredTunnelRibConfig = tunnelRibsConfig.config.get(
      systemColoredTunnelRibName )
   if not systemColoredTunnelRibConfig:
      systemColoredTunnelRibConfig = tunnelRibsConfig.config.newMember(
         systemColoredTunnelRibName )
   tunnelTables = [
      TunnelTableIdentifier.rsvpLerTunnelTable,
      TunnelTableIdentifier.srTePolicyTunnelTable,
      TunnelTableIdentifier.isisFlexAlgoTunnelTable,
   ]
   for tunnelTable in tunnelTables:
      if tunnelTable not in systemColoredTunnelRibConfig.entry:
         systemColoredTunnelRibConfig.entry.newMember( tunnelTable, prefMapping,
                                                       prefMapping )
   for tunnelTable in systemColoredTunnelRibConfig.entry.keys():
      if tunnelTable not in tunnelTables:
         del systemColoredTunnelRibConfig.entry[ tunnelTable ]
   
   tunnelRibNameList = [ systemTunnelingLdpTunnelRibName, 
                         systemIgpShortcutTunnelRibName]
   if IpLibToggleLib.toggleMplsCbfLdpOverRsvpTeEnabled():
      tunnelRibNameList += [ systemColoredTunnelingLdpTunnelRibName ]
   if IpLibToggleLib.toggleMplsCbfSrOverRsvpTeEnabled():
      tunnelRibNameList += [ systemColoredIgpShortcutTunnelRibName ]
   for tunnelRibName in tunnelRibNameList:
      appTunnelRibConfig = tunnelRibsConfig.config.get( tunnelRibName )
      if not appTunnelRibConfig:
         appTunnelRibConfig = tunnelRibsConfig.config.newMember( tunnelRibName )
      tunnelTables = [ TunnelTableIdentifier.rsvpLerTunnelTable ]

      if tunnelRibName == systemIgpShortcutTunnelRibName:
         tunnelTables.append( TunnelTableIdentifier.srTePolicyTunnelTable )

      for tunnelTable in tunnelTables:
         if tunnelTable not in appTunnelRibConfig.entry:
            appTunnelRibConfig.entry.newMember( tunnelTable, prefMapping,
                                                prefMapping )
      for tunnelTable in appTunnelRibConfig.entry.keys():
         if tunnelTable not in tunnelTables:
            del appTunnelRibConfig.entry[ tunnelTable ]

   # Populate systemTunnelRib and systemColoredTunnelRib names and IDs
   tunnelRibNameIdMap = entMan.root().entity[
      "tunnel/tunnelRibs/tunnelRibNameIdMap" ]
   tunnelRibNameIdMap.nameToId[ systemTunnelRibName ] = systemTunnelRibId
   tunnelRibNameIdMap.nameToId[ systemColoredTunnelRibName ] = \
                                                  systemColoredTunnelRibId
   tunnelRibNameIdMap.nameToId[ systemTunnelingLdpTunnelRibName ] = \
                                                  systemTunnelingLdpTunnelRibId
   tunnelRibNameIdMap.nameToId[ systemIgpShortcutTunnelRibName ] = \
                                                  systemIgpShortcutTunnelRibId
   if not IpLibToggleLib.toggleMplsCbfSrOverRsvpTeEnabled() and \
         not IpLibToggleLib.toggleMplsCbfLdpOverRsvpTeEnabled():
      tunnelRibNameIdMap.currentId = systemIgpShortcutTunnelRibId + 1
   if IpLibToggleLib.toggleMplsCbfLdpOverRsvpTeEnabled():
      tunnelRibNameIdMap.nameToId[ systemColoredTunnelingLdpTunnelRibName ] = \
                                                systemColoredTunnelingLdpTunnelRibId
      # Start currentId just past the last system id
      tunnelRibNameIdMap.currentId = systemColoredTunnelingLdpTunnelRibId + 1
   if IpLibToggleLib.toggleMplsCbfSrOverRsvpTeEnabled():
      tunnelRibNameIdMap.nameToId[ systemColoredIgpShortcutTunnelRibName ] = \
                                          systemColoredIgpShortcutTunnelRibId
      # Start currentId just past the last system id
      tunnelRibNameIdMap.currentId =  systemColoredIgpShortcutTunnelRibId + 1

