# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import SysdbUtil
import Tac
import Plugins
from ServicePluginContext import addServiceInfo
from RoutingConsts import defaultStaticRoutePreference

# pkgdeps: rpmwith %{_libdir}/SysdbMountProfiles/ControllerClient

@Plugins.plugin( requires=( 'mgmt/controller/service/config', ) )
def Plugin( entityMan ):
   SysdbUtil.addLogFacility( entityMan, 'VXLAN' )

   vcs = entityMan.lookup( "routing/vrf/input/default/vcs" )
   routingProtocol = Tac.Type( "Routing::RoutingProtocol" )
   vcs.routingProto = routingProtocol.vcs
   vcs.defaultPreference = defaultStaticRoutePreference
   vcs.showIpRouteKey = "V"
   vcs.redistributeName = "VCS"

   # After the VxlanClientConfig tristate refactor, we can just unconditionally
   # enable the CLI VxlanClientConfig.  All of the flags will remain unset and
   # won't affect VxlanClientConfig processing until they're explicitly set by
   # the various CLI handlers
   vxlanCliClientConfig = entityMan.lookup( "vxlan/clientDir/cli" )
   vxlanCliClientConfig.enabled = True

   clientVersions = ( ( 2, 'Second version of Vxlan Control Service' ), )
   addServiceInfo( entityMan.serviceClientCtx_, 'Vxlan', clientVersions )
