# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import binascii
import os
import hashlib
import string
import Tac

SwitchportModeAndNativeVlan = Tac.Type( "Bridging::SwitchportModeAndNativeVlan" )
Dot1xConsts = Tac.Type( "Dot1x::Dot1xConstants" )
Dot1xAclInputPriority = Tac.Type( "Dot1x::Dot1xAclInputPriority" )
EscapedString = Tac.Type( "Lldp::EscapedString" )
portControlStr2Enum = { 'auto' : 'controlled',
                        'force-authorized' : 'forceAuth',
                        'force-unauthorized' : 'forceUnauth' }
portControlEnum2Str = { 'controlled' : 'auto',
                        'forceAuth' : 'force-authorized',
                        'forceUnauth' : 'force-unauthorized' }
portStatusEnum2Str = { 'blocked' : 'Unauthorized',
                       'authorized' : 'Authorized',
                       'guestVlan' : 'Authorized(GUEST-VLAN)',
                       'restrictedVlan' : 'Authorized(AUTH-FAIL-VLAN)' }
portStatusStr2Enum = { 'Unauthorized' : 'blocked',
                       'Authorized' : 'authorized',
                       'Authorized(GUEST-VLAN)' : 'guestVlan',
                       'Authorized(AUTH-FAIL-VLAN)' : 'restrictedVlan' }
hostModeStr2Enum = { 'single-host' : 'singleHost',
                     'multi-host' : 'multiHost',
                     'multi-host authenticated' : 'authAllHost' }
hostModeEnum2Str = { 'singleHost' : 'single-host',
                     'multiHost' : 'multi-host',
                     'authAllHost' : 'multi-host authenticated' }
sessionReplaceDetectionActionEnum2Str = { 'logOnly': 'emit log',
                                          'errdisable': 'disable interface' }
sessionReplaceDetectionActionStr2Enum = { 'emit log': 'logOnly',
                                          'disable interface': 'errdisable' }
nasPortTypeEnum2Str = { 'ethernet': 'Ethernet',
                        'virtual': 'Virtual' }

MAX_SUPPLICANT_KEY_SIZE = 128
MAX_SUPPLICANT_ID_SIZE = 128

"""Dot1x Host class encapsulates supplicant information for 802.1x and MBA
supplicants."""
authStageDict = { "idle" : 'IDLE', "authWaitForSupplicant": 'WAIT-FOR-SUPPLICANT',
                  'authWaitForAuthServer' : 'WAIT-FOR-AUTH-SERVER',
                  'reAuthWaitForSupplicant': 'RE-WAIT-FOR-SUPPLICANT',
                  'reAuthWaitForAuthServer': 'RE-WAIT-FOR-AUTH-SERVER',
                  'successfulAuth': 'SUCCESS',
                  'supplicantTimeout': 'SUPPLICANT-TIMEOUT',
                  'authServerTimeout': 'AUTH-SERVER-TIMEOUT',
                  'failedAuth': 'FAILED',
                  'failedMvrp': 'FAILED',
                  'failedUntaggedDynVlan': 'FAILED-DYN-VLAN',
                  'failedTaggedDynVlan': 'FAILED-TAG-DYN-VLAN',
                  'failedInternalVlan': 'FAILED-INTERNAL-VLAN-CONFLICT',
                  'failedAclAttachment': 'FAILED-ACL-ATTACH',
                  'failedDynamicAclCreation': 'FAILED-DYN-ACL-CREATION',
                  'failedStaticAndDynamicAcl': 'FAILED-UNSUPP-STATIC-AND-DYN-ACL',
                  'webAuthStart': 'WEB-AUTH-START',
                  'failedWebAuth': 'WEB-AUTH-FAILED',
                  # TODO: Create separate Log message as part of BUG451606.
                  'failedVlanName': 'FAILED-DYN-VLAN',
                  'pendingDeletion': 'PENDING-DELETION',
                  'failedInvalidAttribute': 'FAILED-INVALID-ATTRIBUTE',
                  }

# Shorten few long stages in above dictionary only for CLI outputs
# Adding to authStageDict any new stage same as those in below will have side effects
cliStageShorten = {
      'FAILED-INTERNAL-VLAN-CONFLICT': 'FAILED-VLAN-CONFLICT',
      'FAILED-UNSUPP-STATIC-AND-DYN-ACL': 'FAILED-UNSUPP-ACL',
}

authMethodDict = {
      "eapol" : "EAPOL",
      "mba" : "MAC-BASED-AUTH"
      }

reAuthBehaviour = {
      "reauth": "RE-AUTH",
      "dropThenReauth": "DROP-AND-RE-AUTH",
      "doNotReauth": "DO-NOT-RE-AUTH"
      }

def aristaWebAuth( webAuth ):
   return webAuth.capitalize()

framedIpAddrSourceDict = [ 'sourceNone', 'sourceL3NbrByGnmi', 'sourceAaaAccept',
                           'sourceIpLocking', 'sourceArp', 'sourceLldp' ]

serviceTypes = [
      'Invalid', 'Login-User', 'Framed-User', 'Callback-Login-User',
      'Callback-Framed-User', 'Outbound-User', 'Administrative-User',
      'NAS-Prompt-User', 'Authenticate-Only', 'Callback-NAS-Prompt',
      'Call-Check', 'Callback-Administrative' ]

terminationActionDict = [ 'DEFAULT', 'RADIUS-REQUEST' ]

shortenAuthMethod = {
      'MAC-BASED-AUTH': 'MBA',
      'EAPOL': 'EAPOL',
      'AUTH-PHONE': 'PHONE'
      }

shortenFallback = {
      'fallbackNone': 'NONE',
      'fallbackAuthFail': 'AUTH-FAIL-VLAN',
      'fallbackGuestVlan': 'GUEST-VLAN',
      'fallbackAaaUnresponsivePhone': 'UNRESPONSIVE-PHONE',
      'fallbackAaaUnresponsiveAgnosticNative': 'UNRESPONSIVE',
      'fallbackAaaUnresponsiveAgnosticSpecific': 'UNRESPONSIVE'
      }

enabledDisabled = {
   False: "disabled",
   True: "enabled"
}

def escapedString( origString ):
   """Return a string with all non-ASCII and ASCII control codes escaped"""
   return EscapedString.fromBytes( origString )

def escapedClassHex( data ):
   # ServiceClass can be a byte array but may contain non Unicode characters
   # print the non byte version if possible else print the byte array
   try:
      byStr = binascii.unhexlify( data ).decode()
      printset = set( string.printable )
      if set( byStr ).issubset( printset ):
         return byStr
   except ( binascii.Error, TypeError, UnicodeDecodeError ):
      pass

   return repr( data ).lstrip( "b" ).strip( "'" )

# Mostly copied from SslCertKey.generateKeyCertHash
def hashFile( filepath, blockSize=65536 ):
   if not os.path.exists( filepath ):
      return None
   sha256sum = hashlib.sha256()
   with open( filepath, "rb" ) as fd:
      for block in iter( lambda: fd.read( blockSize ), b'' ):
         sha256sum.update( block )
   return sha256sum.hexdigest()
