#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Ethernet
import Tac
import Tracing
from EbraTestBridgePythonImpl import (
      ArfaShimPacketReplicationHandler,
      getPythonIntoCppShimContext,
)

handle = Tracing.Handle( 'ArpSuppression' )
t2 = handle.trace2

def packetReplicationHandler( bridge, finalIntfs, srcPort=None, dropReasonList=None,
                              vlanId=None, dstMacAddr=None, data=None ):
   if dropReasonList:
      return
   if dstMacAddr is None:
      assert srcPort is None
      return
   if not ( Ethernet.isBroadcast( dstMacAddr ) or
            Ethernet.isIPv6Multicast( dstMacAddr ) ):
      return
   assert srcPort
   assert vlanId is not None
   assert data

   # Call into the C++ ArpSuppression plugin
   shim = getPythonIntoCppShimContext()
   assert shim

   plugin = shim.plugin( "ArpSuppression" )
   assert plugin

   pktCtx = shim.pktCtx( data, srcPort.name() )
   shimClass = ArfaShimPacketReplicationHandler( plugin.decisionStep )
   shimClass( bridge,
              finalIntfs,
              srcPort=srcPort,
              dropReasonList=dropReasonList,
              vlanId=vlanId,
              dstMacAddr=dstMacAddr,
              data=data,
              pktCtx=pktCtx )

   shim.callBridgingActionStepPktCtx( plugin.actionStep, pktCtx )

def Plugin( ctx ):
   t2( 'Entering Plugin() in ArpSuppression.py' )
   ctx.registerPacketReplicationHandler( packetReplicationHandler )
