#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import EbraTestBridgeConstants
from Arnet import PktParserTestLib

perlinkMode = Tac.Type( "Bfd::PerlinkMode" )

handle = Tracing.Handle( 'EbraTestBridge' )
t2 = handle.trace2
t6 = handle.trace6

BFD_PORT_CTRL = 3784
BFD_PORT_ECHO = 3785
BFD_PORT_LAG = 6784

def isBfdPacket( data ):
   headers = PktParserTestLib.parsePktStr( data )[ 1 ]
   udpHdr = PktParserTestLib.findHeader( headers, "UdpHdr" )
   if udpHdr:
      t6( "UDP Packet, dest port =", udpHdr.dstPort )
      # these are the only ports that need per-link support
      if udpHdr.dstPort in [ BFD_PORT_LAG, BFD_PORT_CTRL, BFD_PORT_ECHO, ]:
         return True
   return False

# Global sysdb mount points to get which interfaces are on perlink mode
bfdConfigIntf = None

# Global sysdb mount points to find interfaces which are within a LAG
configBfdLag = None

def perLinkConfigured( intfName ):
   if ( intfName in bfdConfigIntf.perLink and
         bfdConfigIntf.perLink[ intfName ] != perlinkMode.none ):
      return True
   return False

def isLagMemberInterface( intfName ):
   for poName in configBfdLag.bfdLagConfig:
      bfdLagConfig = configBfdLag.bfdLagConfig[ poName ]
      if intfName in bfdLagConfig.bfdReqPort and perLinkConfigured( poName ):
         return True
   return False

def trapLookupHandler( bridge, routed, vlanId, destMac, data, srcPortName ):
   match = False
   trap = False
   copyToCpu = False
   if isBfdPacket( data ) and isLagMemberInterface( srcPortName ):
      t6( "Bfd trapping to CPU" )
      match = True
      trap = EbraTestBridgeConstants.TRAP_ANYWAY
   return ( match, trap, copyToCpu )

def agentInit( em ):
   t2( "Bfd plugin agentInit" )
   mg = em.mountGroup()
   global bfdConfigIntf
   bfdConfigIntf = mg.mount( 'bfd/config/intf', 'Bfd::ConfigIntf', 'r' )
   global configBfdLag
   configBfdLag = mg.mount( 'bfd/config/lag', 'Bfd::ConfigBfdLag', 'r' )

   def onMountComplete():
      t2( "Bfd agentInit mount complete" )
   mg.close( onMountComplete )

def Plugin( ctx ):
   ctx.registerTrapLookupHandler( trapLookupHandler,
                                  priority=ctx.TRAP_PRIORITIES[ "DEFAULT" ] )
   ctx.registerAgentInitHandler( agentInit )
