#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
from EbraTestBridgePythonImpl import getPythonIntoCppShimContext
handle = Tracing.Handle( 'IntEtbaPlugin' )
t0 = handle.trace0

def performSampling( bridge, data, srcPort, finalIntfs ):
   if not finalIntfs:
      return
   shim = getPythonIntoCppShimContext()
   assert shim
   intPlugin = shim.plugin( "InbandTelemetry" )
   assert intPlugin
   pkt = shim.createPkt( data )
   cSrcPort = shim.getPort( srcPort.name() )
   cDstPort = shim.getPort( next( iter( finalIntfs ) ) )

   intPlugin.intSamplerHelper.maybeSampleEgress( pkt, cSrcPort.intfId,
                                                      cDstPort )

def Plugin( ctx ):
   t0( 'Entering Plugin( ctx ) in EbraTestBridgePlugin/IntDut.py' )
   ctx.registerSflowHandler( performSampling )
