#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
from EbraTestBridgePythonImpl import getPythonIntoCppShimContext

handle = Tracing.Handle( 'IpLocking' )
t8 = handle.trace8

def preBridgingLookup( bridge, data, srcMacAddr, dstMacAddr, srcPort ):
   shim = getPythonIntoCppShimContext()
   assert shim

   pktCtx = shim.pktCtx( data, srcPort.name() )

   ipLockingPlugin = shim.plugin( "IpLocking" )
   assert ipLockingPlugin

   shouldPermit = ipLockingPlugin.inputStep.process( pktCtx )

   return 'permit' if shouldPermit else 'deny'

def Plugin( ctx ):
   t8( 'Entering Plugin(ctx) in IpLocking.py' )
   ctx.registerPreBridgingHandler( preBridgingLookup )
